/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Entity.MenuOption;
import Entity.Mouse;
import Entity.PlayerSave;
import GameState.GameState;
import GameState.GameStateManager;
import Handlers.Content;
import Handlers.Keys;
import Handlers.Options;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.JOptionPane;

public class HighScoresState
extends GameState {
    private Font font;
    private Font fontBig;
    private MenuOption mo;
    private Mouse mouse;
    private int currentChoice = 0;
    private String[] options = new String[]{"Change Local/Online", "Change Difficulty", "Back"};
    private int prevDifficulty;
    private String prevOnlineText;

    public HighScoresState(GameStateManager gsm) {
        this.gsm = gsm;
        PlayerSave.getHighScores(false);
        this.font = new Font("Arial", 0, 22);
        this.fontBig = new Font("Arial", 0, 28);
        this.mo = new MenuOption(this.options, this.font, 400, 285, 0, 35);
        this.mouse = new Mouse();
        this.prevDifficulty = PlayerSave.getDifficulty();
        this.prevOnlineText = PlayerSave.onlineText;
    }

    @Override
    public void init() {
    }

    @Override
    public void update() {
        this.handleInput();
        this.mo.update(this.mouse);
        this.mouse.update();
    }

    @Override
    public void draw(Graphics2D g) {
        g.drawImage((Image)Content.MenuBG, 0, 0, null);
        g.setFont(this.fontBig);
        g.setColor(Color.white);
        this.gsm.drawCenteredString("--> High Scores - " + PlayerSave.difficultyString + " (" + PlayerSave.onlineText + ") <--", 800, 70, g);
        PlayerSave.drawHighScore(g, this.font, 150, 90);
        g.setFont(this.gsm.regFont);
        if (Options.getOption(5)) {
            this.mo.draw(g);
            this.mouse.draw(g);
        } else {
            int i = 0;
            while (i < this.options.length) {
                if (i == this.currentChoice) {
                    g.setColor(Color.YELLOW);
                } else {
                    g.setColor(Color.WHITE);
                }
                this.gsm.drawCenteredString(this.options[i], 800, 575 + i * 70, g);
                ++i;
            }
        }
    }

    private void select(int currentChoice) {
        if (currentChoice == 0) {
            if (Options.getOption(6)) {
                if (PlayerSave.online) {
                    PlayerSave.setOnline(false);
                } else {
                    PlayerSave.setOnline(true);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Online Leaderboards Is Turned Off In Your Settings!");
            }
        }
        if (currentChoice == 1) {
            if (PlayerSave.getDifficulty() == 0) {
                PlayerSave.setDifficulty(1);
            } else if (PlayerSave.getDifficulty() == 1) {
                PlayerSave.setDifficulty(2);
            } else if (PlayerSave.getDifficulty() == 2) {
                PlayerSave.setDifficulty(0);
            }
        }
        if (currentChoice == 2) {
            PlayerSave.setDifficulty(this.prevDifficulty);
            PlayerSave.onlineText = this.prevOnlineText;
            this.gsm.setState(0);
        }
    }

    @Override
    public void handleInput() {
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            this.gsm.setState(0);
        }
        if (Options.getOption(5)) {
            if (Keys.isMousePressed(Keys.LEFTCLICK)) {
                this.select(this.mo.getChoice());
            }
        } else {
            if (Keys.isKeyPressed(Keys.ENTER)) {
                this.select(this.currentChoice);
            }
            if (Keys.isKeyPressed(Keys.UP)) {
                this.currentChoice = this.currentChoice > 0 ? --this.currentChoice : this.options.length - 1;
            }
            if (Keys.isKeyPressed(Keys.DOWN)) {
                this.currentChoice = this.currentChoice < this.options.length - 1 ? ++this.currentChoice : 0;
            }
        }
    }
}

